# Willmott 1799 Census of Carrick-on-Suir — Faithful DataEase Extraction Pack

This package was generated to preserve and make usable the full DataEase application provided by Michael Coady (historian), while maintaining integrity and provenance.

## What is included

1. `00_manifest/` — provenance and structure
   - `files_manifest.csv` (SHA-256 hashes, sizes, mtimes)
   - `application_map.md` (file grouping / likely roles)

2. `01_raw_app/` — the original DataEase files extracted from the ZIP (unchanged)

3. `02_extracted_tables/` — extracted views designed to be *non-destructive*:
   - `HOUSHAAB/households.csv` (house_ref, street, area, occupants_raw)
   - `HOUSHAAB/people_in_households.csv` (best-effort person rows parsed from household occupants)
   - `CHILHAAA/children_people.csv` (best-effort person rows from children listing)
   - `SERVHAAA/servants_people.csv` (best-effort person rows from servants listing)
   - `MARRHAAB/marriage_segments.csv` (household-level blocks preserved for later modelling)
   - `_ascii_extracts/` (ASCII-runs extracted from many binary files for research/debugging)

## Integrity / caution

- No files under `01_raw_app/` were modified.
- Parsed CSVs are **best-effort** interpretations of fixed-width memo content and should be treated as derived products.
- For auditability, `occupants_raw` and `blob_clean` columns retain large portions of the original record text.

## Next steps

- Use `files_manifest.csv` to verify integrity after copying/storage.
- Use the extracted CSVs as the basis for WordPress import and/or further modelling.
- If desired, we can iterate on decoding of codes (sex/marital/category) using Michael Coady's original conventions.

## Relationship-first outputs (added)

- `02_extracted_tables/_relationships/house_ref_coverage.csv` — coverage matrix of which house refs appear in which per-house objects.
- `02_extracted_tables/_relationships/people_unified.csv` — unified people table combining household/children/servants with provenance.
- Additional per-house exports: `*/segments_by_house_ref.csv` for objects with per-house memo blocks.

## DICTHAAA / RELAHAAA decoding (added)

- `02_extracted_tables/RELAHAAA/relationships.csv` — decoded relationship list from `RELAHAAA.DBM`.
- `DICTHAAA.DBM` in this ZIP is zero bytes; no dictionary entries could be extracted.

## MENUHAAA / TOWNHAAA decoding (added)

- `02_extracted_tables/MENUHAAA/menu_pairs.csv` — menu command/label pairs.
- `02_extracted_tables/TOWNHAAA/tosearch_tokens.csv` — tokens extracted from `TOWNHAAA.DBR` describing the town-wide surname search form/report.
- `PRINHAAA.DBM` is zero bytes in this archive; print/report definitions may reside elsewhere.

## Presentation-layer decoding (DBR/SCR/FMT/FMO) (added)

- `02_extracted_tables/_presentation/presentation_map.csv` — per-file token extraction summary for DBR/SCR/FMT/FMO.
- `02_extracted_tables/_presentation/presentation_keyword_hits.csv` — quick index of files containing key historian-facing terms.
- `02_extracted_tables/_presentation/search_forms.csv` — structured token lists for `SEARHAA*` search forms.
- Each stem directory also now contains `<STEM>_tokens.csv` for its DBR/SCR/FMT/FMO files.

## Additional module decoding (ADDENDA/WADDING/GRAVESTONES) (added)

- `02_extracted_tables/ADDEHAAA/addehaaa_segments.csv` — addenda memo segments keyed by house_ref.
- `02_extracted_tables/GRAVHAAA/gravhaaa_segments.csv` — gravestone memo segments keyed by 8-digit record key.
- `02_extracted_tables/WADDHAAA/waddhaaa_blob.csv` — full WADDING memo blob preserved (single-record in this archive).
- `02_extracted_tables/GRAVHAAB/gravhaab_blob.csv` — full GRAVESTONE2 memo blob preserved (single-record in this archive).
- `02_extracted_tables/_relationships/schema_dictionary.json` — reconstructed object map + decoded relationships.
- `02_extracted_tables/_relationships/schema_narrative.md` — readable relationship narrative.

## HOUSE/STREET/HOUSEHOLD concepts + GRAVESTONE linking (added)

- `02_extracted_tables/_relationships/gravestone_house_links.csv` — high-confidence linking of gravestone records to house_ref.
- `02_extracted_tables/_relationships/concepts_house_street_household.json` — evidence-backed concept definitions.
- `02_extracted_tables/_relationships/street_house_household_gravestone_linking.md` — readable note for historians/devs.

## UNMARRIED module references (added)

- `UNMAHAAB.DBR` decodes to a transform process `UNMARTRANS` referencing `UNMARRIED1799` and `BURGERS`.
- Outputs:
  - `02_extracted_tables/UNMAHAAB/UNMAHAAB_tokens.csv`
  - `02_extracted_tables/UNMAHAAB/unmarried_transform_notes.md`
- Note: the referenced objects (`UNMARRIED1799`, `BURGERS`) do not exist as file stems in this archive; they may be logical objects within the application.
