# STREET / HOUSE / HOUSEHOLD concepts and GRAVESTONE linking (reconstructed)

This note records evidence-based interpretations of the DataEase application's conceptual objects.
It is derived from decoded presentation tokens (notably `TOWNSEARCH`) and module memo content.

## HOUSE (reference key)

- **Inferred meaning:** The primary reference number for a census household, used to join modules.
- **Evidence:** `TOWNSEARCH` table header includes `REF` and `HOUSE`, and ordering rules reference `HOUSE`.

## STREET

- **Inferred meaning:** Street/address label associated with a house/household.
- **Evidence:** `TOWNSEARCH` header includes `STREET`, and ordering rules reference street ordering.

## HOUSEHOLD

- **Inferred meaning:** A household-level record that combines HOUSE (ref), STREET, and occupant surnames.
- **Evidence:** `for HOUSEHOLD` tokens in `TOWNSEARCH` and its column set REF/HOUSE/STREET/SURNAME.

## GRAVESTONE linking

The `GRAVESTONE` module (`GRAVHAAA`) contains 8-digit keys that match household house references in this archive.
All extracted gravestone segments had a record key that is also a valid `house_ref`, giving a **high confidence** link.

- Output: `02_extracted_tables/_relationships/gravestone_house_links.csv`
- Link type: `record_key == house_ref` (confidence: HIGH for all segments in this archive)

## Quoted token evidence (TOWNSEARCH)

- TOWNSEARCH
- HOUSEHOLD
- HOUSE
- STREET
- SURNAME
- for HOUSEHOLD
- HOUSE ;
- STREET in order ;
- REF     HOUSE                 STREET                      SURNAME
