# Willmott 1799 (Carrick-on-Suir) — DataEase schema narrative (reconstructed)

This document summarises the reconstructed object model of the DataEase application, based on:
- decoded relationship list (`RELAHAAA`)
- per-object memo segmentation
- menu and presentation token extraction

## Core join key

Most census modules join on an 8-digit **HOUSE** key (`house_ref` in the derived exports).

## Objects and how they relate

- **GRAVESTONE** (CORPSE) ↔ **GRAVESTONE2** (CORPSE)
- **1799HOUSEKEEPERS** (HOUSE) ↔ **WADDING** (HOUSE)
- **1799HOUSEKEEPERS** (HOUSE) ↔ **ADDENDA** (HOUSE)
- **STREET** (1799HOUSEKEEPERS) ↔ **STREET** (GRAVESTONE)
- **HOUSE** (1799HOUSEKEEPERS) ↔ **HOUSE** (GRAVESTONE2)
- **HOUSE** (WADDING) ↔ **HOUSE** (1799CHILDREN)
- **HOUSE** (1799CHILDREN) ↔ **HOUSE** (ADDENDA)
- **HOUSE** (STREET) ↔ **HOUSE** (STREET)
- **1799HOUSEKEEPERS** (HOUSE) ↔ **1799CHILDREN** (HOUSE)
- **1799MARRIED** (HOUSE) ↔ **ADDENDA** (HOUSE)
- **1799HOUSEKEEPERS** (HOUSE) ↔ **1799MARRIED** (HOUSE)
- **1799MARRIED** (HOUSE) ↔ **1799CHILDREN** (HOUSE)
- **WADDING** (HOUSE) ↔ **1799SERV/APPR** (HOUSE)
- **1799SERV/APPR** (HOUSE) ↔ **ADDENDA** (HOUSE)
- **STREET** (1799HOUSEKEEPERS) ↔ **STREET** (1799SERV/APPR)
- **HOUSE** (STREET) ↔ **HOUSE** (STREET)
- **1799CHILDREN** (HOUSE) ↔ **1799SERV/APPR** (HOUSE)
- **1799SERV/APPR** (HOUSE) ↔ **1799MARRIED** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **ADDENDA** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **GRAVESTONE** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **GRAVESTONE2** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **1799HOUSEKEEPERS** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **1799CHILDREN** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **1799MARRIED** (HOUSE)
- **HOUSEHOLD** (HOUSE) ↔ **1799SERV/APPR** (HOUSE)

## Module mapping to file stems

### 1799HOUSEKEEPERS
- File stems: HOUSHAAB, HOUSHAAA
- Extracted exports:
  - `02_extracted_tables/HOUSHAAB/households.csv`
  - `02_extracted_tables/HOUSHAAB/people_in_households.csv`
  - `02_extracted_tables/HOUSHAAB/segments_by_house_ref.csv`
  - `02_extracted_tables/HOUSHAAA/segments_by_house_ref.csv`

### 1799CHILDREN
- File stems: CHILHAAA
- Extracted exports:
  - `02_extracted_tables/CHILHAAA/children_people.csv`
  - `02_extracted_tables/CHILHAAA/segments_by_house_ref.csv`
  - `02_extracted_tables/CHILHAAA/CHILHAAA_tokens.csv`

### 1799SERV/APPR
- File stems: SERVHAAA
- Extracted exports:
  - `02_extracted_tables/SERVHAAA/servants_people.csv`
  - `02_extracted_tables/SERVHAAA/segments_by_house_ref.csv`

### 1799MARRIED
- File stems: MARRHAAB
- Extracted exports:
  - `02_extracted_tables/MARRHAAB/marriage_segments.csv`
  - `02_extracted_tables/MARRHAAB/segments_by_house_ref.csv`
  - `02_extracted_tables/MARRHAAB/MARRHAAB_tokens.csv`

### ADDENDA
- File stems: ADDEHAAA
- Extracted exports:
  - `02_extracted_tables/ADDEHAAA/segments_by_house_ref.csv`
  - `02_extracted_tables/ADDEHAAA/addehaaa_segments.csv`

### WADDING
- File stems: WADDHAAA
- Extracted exports:
  - `02_extracted_tables/WADDHAAA/WADDHAAA_tokens.csv`
  - `02_extracted_tables/WADDHAAA/waddhaaa_blob.csv`

### GRAVESTONE
- File stems: GRAVHAAA
- Extracted exports:
  - `02_extracted_tables/GRAVHAAA/gravhaaa_segments.csv`

### GRAVESTONE2
- File stems: GRAVHAAB
- Extracted exports:
  - `02_extracted_tables/GRAVHAAB/gravhaab_blob.csv`

### RELA
- File stems: RELAHAAA
- Extracted exports:
  - `02_extracted_tables/RELAHAAA/relationships.csv`

### MENU
- File stems: MENUHAAA
- Extracted exports:
  - `02_extracted_tables/MENUHAAA/menu_pairs.csv`

### TOWNSEARCH
- File stems: TOWNHAAA
- Extracted exports:
  - `02_extracted_tables/TOWNHAAA/tosearch_tokens.csv`
  - `02_extracted_tables/TOWNHAAA/TOWNHAAA_tokens.csv`

## Notes on GRAVESTONE modules

The gravestone modules appear to use an 8-digit key that is likely **CORPSE** (per RELAHAAA),
and are linked to household/house modules via a HOUSE key at the application level.
In this archive, `GRAVHAAA` yields multiple segments keyed by an 8-digit identifier; `GRAVHAAB` appears as a single memo blob.
