# Willmott 1799 Carrick-on-Suir — DataEase application file map (extracted)

This map groups files by their base stem (before the extension). DataEase uses multiple companion files per logical object.

## High-level notes

- `*.DBM` files hold substantial text/memo-like content used by the application.
- `*.DBA` files typically store form/report definitions (application logic).
- `*.DBR` and `*.I*` are index/relationship structures.
- `*.DBF` present here do not appear to be standard dBase DBF; treat as DataEase table binaries.

## Objects

### ADDEHAAA
- Files (3):
  - ADDEHAAA.DBA
  - ADDEHAAA.DBM
  - ADDEHAAA.I01

### CATALOG
- Files (1):
  - CATALOG.CAT

### CHILHAAA
- **Likely role:** Children listing (by household)
- Files (16):
  - CHILHAAA.DBA
  - CHILHAAA.DBM
  - CHILHAAA.DBR
  - CHILHAAA.I02
  - CHILHAAA.I04
  - CHILHAAA.I0B
  - CHILHAAA.I12
  - CHILHAAA.I19
  - CHILHAAA.I20
  - CHILHAAA.I27
  - CHILHAAA.I2E
  - CHILHAAA.I35
  - CHILHAAA.I3C
  - CHILHAAA.I43
  - CHILHAAA.I4A
  - CHILHAAA.I51

### CHILHAAB
- Files (2):
  - CHILHAAB.DBF
  - CHILHAAB.DBR

### CONFHAAA
- Files (1):
  - CONFHAAA.DBM

### CUSTHAAA
- Files (1):
  - CUSTHAAA.DBM

### DICTHAAA
- **Likely role:** Dictionary / code lookups (occupations, streets?)
- Files (1):
  - DICTHAAA.DBM

### DYSAHAAA
- Files (2):
  - DYSAHAAA.DBA
  - DYSAHAAA.DBM

### EXTRHAAA
- Files (1):
  - EXTRHAAA.DBM

### FARGHAAA
- Files (1):
  - FARGHAAA.DBR

### FEMAHAAA
- Files (2):
  - FEMAHAAA.DBA
  - FEMAHAAA.DBM

### GRAVHAAA
- **Likely role:** Gravestone-related notes/listing
- Files (4):
  - GRAVHAAA.DBA
  - GRAVHAAA.DBM
  - GRAVHAAA.I01
  - GRAVHAAA.I02

### GRAVHAAB
- **Likely role:** Gravestone related (aux)
- Files (4):
  - GRAVHAAB.DBA
  - GRAVHAAB.DBM
  - GRAVHAAB.I01
  - GRAVHAAB.I02

### HKEXHAAA
- Files (1):
  - HKEXHAAA.DBR

### HOUSHAAA
- **Likely role:** Household index/auxiliary (house refs and navigation?)
- Files (5):
  - HOUSHAAA.DBA
  - HOUSHAAA.DBM
  - HOUSHAAA.I01
  - HOUSHAAA.I05
  - HOUSHAAA.I0B

### HOUSHAAB
- **Likely role:** Households (core census households; street/area + occupants list)
- Files (51):
  - HOUSHAAB.DBA
  - HOUSHAAB.DBM
  - HOUSHAAB.I01
  - HOUSHAAB.I05
  - HOUSHAAB.I0A
  - HOUSHAAB.I0F
  - HOUSHAAB.I14
  - HOUSHAAB.I19
  - HOUSHAAB.I1E
  - HOUSHAAB.I23
  - HOUSHAAB.I28
  - HOUSHAAB.I2D
  - HOUSHAAB.I32
  - HOUSHAAB.I37
  - HOUSHAAB.I3C
  - HOUSHAAB.I41
  - HOUSHAAB.I46
  - HOUSHAAB.I4B
  - HOUSHAAB.I50
  - HOUSHAAB.I55
  - HOUSHAAB.I5A
  - HOUSHAAB.I5F
  - HOUSHAAB.I64
  - HOUSHAAB.I69
  - HOUSHAAB.I6E
  - HOUSHAAB.I73
  - HOUSHAAB.I78
  - HOUSHAAB.I7D
  - HOUSHAAB.I82
  - HOUSHAAB.I87
  - HOUSHAAB.I8C
  - HOUSHAAB.I91
  - HOUSHAAB.I96
  - HOUSHAAB.I9B
  - HOUSHAAB.IA0
  - HOUSHAAB.IA5
  - HOUSHAAB.IAA
  - HOUSHAAB.IAF
  - HOUSHAAB.IB4
  - HOUSHAAB.IB9
  - HOUSHAAB.IBE
  - HOUSHAAB.IC3
  - HOUSHAAB.IC8
  - HOUSHAAB.ICD
  - HOUSHAAB.ID2
  - HOUSHAAB.ID7
  - HOUSHAAB.IDC
  - HOUSHAAB.IE1
  - HOUSHAAB.IE6
  - HOUSHAAB.IEB
  - HOUSHAAB.IF0

### KEEPHAAA
- Files (2):
  - KEEPHAAA.DBF
  - KEEPHAAA.DBR

### LOTEHAAA
- Files (1):
  - LOTEHAAA.DBR

### MARRHAAA
- Files (3):
  - MARRHAAA.DBA
  - MARRHAAA.DBM
  - MARRHAAA.I04

### MARRHAAB
- **Likely role:** Marriage/couple listing (by household)
- Files (26):
  - MARRHAAB.DBA
  - MARRHAAB.DBM
  - MARRHAAB.DBR
  - MARRHAAB.I02
  - MARRHAAB.I05
  - MARRHAAB.I0C
  - MARRHAAB.I13
  - MARRHAAB.I1A
  - MARRHAAB.I21
  - MARRHAAB.I28
  - MARRHAAB.I2F
  - MARRHAAB.I36
  - MARRHAAB.I3D
  - MARRHAAB.I44
  - MARRHAAB.I4B
  - MARRHAAB.I52
  - MARRHAAB.I59
  - MARRHAAB.I60
  - MARRHAAB.I67
  - MARRHAAB.I6E
  - MARRHAAB.I75
  - MARRHAAB.I7C
  - MARRHAAB.I83
  - MARRHAAB.I8A
  - MARRHAAB.I91
  - MARRHAAB.I98

### MARRHAAC
- Files (2):
  - MARRHAAC.DBF
  - MARRHAAC.DBR

### MARRHAAD
- Files (2):
  - MARRHAAD.DBF
  - MARRHAAD.DBR

### MARTHAAA
- Files (1):
  - MARTHAAA.DBR

### MENUHAAA
- **Likely role:** Menu definitions
- Files (1):
  - MENUHAAA.DBM

### MOREHAAA
- Files (1):
  - MOREHAAA.DBR

### MOTHHAAA
- Files (2):
  - MOTHHAAA.DBA
  - MOTHHAAA.DBM

### PRINHAAA
- **Likely role:** Print/report definitions
- Files (1):
  - PRINHAAA.DBM

### PRODHAAA
- Files (1):
  - PRODHAAA.DBR

### RDRRHAAA
- Files (1):
  - RDRRHAAA.DBM

### RDRSHAAA
- Files (1):
  - RDRSHAAA.DBM

### RELAHAAA
- **Likely role:** Relationships/links table (likely between people)
- Files (1):
  - RELAHAAA.DBM

### REMSHAAA
- Files (2):
  - REMSHAAA.DBF
  - REMSHAAA.DBR

### REPOHAAA
- Files (1):
  - REPOHAAA.DBM

### SCREHAAA
- Files (1):
  - SCREHAAA.DBM

### SEARHAAC
- Files (2):
  - SEARHAAC.DBF
  - SEARHAAC.DBR

### SEARHAAD
- Files (2):
  - SEARHAAD.DBF
  - SEARHAAD.DBR

### SEARHAAE
- Files (2):
  - SEARHAAE.DBF
  - SEARHAAE.DBR

### SEARHAAF
- Files (2):
  - SEARHAAF.DBF
  - SEARHAAF.DBR

### SEARHAAG
- Files (2):
  - SEARHAAG.DBF
  - SEARHAAG.DBR

### SEARHAAH
- Files (2):
  - SEARHAAH.DBF
  - SEARHAAH.DBR

### SERTHAAA
- Files (1):
  - SERTHAAA.DBR

### SERVHAAA
- **Likely role:** Servants listing (by household)
- Files (15):
  - SERVHAAA.DBA
  - SERVHAAA.DBM
  - SERVHAAA.I02
  - SERVHAAA.I04
  - SERVHAAA.I0B
  - SERVHAAA.I12
  - SERVHAAA.I19
  - SERVHAAA.I20
  - SERVHAAA.I27
  - SERVHAAA.I2E
  - SERVHAAA.I35
  - SERVHAAA.I3C
  - SERVHAAA.I43
  - SERVHAAA.I4A
  - SERVHAAA.I51

### SERVHAAB
- Files (2):
  - SERVHAAB.DBF
  - SERVHAAB.DBR

### SUBSHAAA
- Files (3):
  - SUBSHAAA.DBA
  - SUBSHAAA.DBM
  - SUBSHAAA.I02

### TABLHAAA
- Files (2):
  - TABLHAAA.DBA
  - TABLHAAA.DBM

### TABLHAAB
- Files (2):
  - TABLHAAB.DBA
  - TABLHAAB.DBM

### TOWNHAAA
- **Likely role:** Town/places lookup
- Files (2):
  - TOWNHAAA.DBF
  - TOWNHAAA.DBR

### TRADHAAA
- Files (2):
  - TRADHAAA.DBA
  - TRADHAAA.DBM

### TRANHAAA
- Files (1):
  - TRANHAAA.DBR

### UNMAHAAB
- Files (1):
  - UNMAHAAB.DBR

### UNTITLED
- Files (1):
  - UNTITLED.CAT

### USERHAAA
- Files (1):
  - USERHAAA.DBM

### WADDHAAA
- Files (4):
  - WADDHAAA.DBA
  - WADDHAAA.DBM
  - WADDHAAA.DBR
  - WADDHAAA.I04


## Decoding notes

### RELAHAAA

- `RELAHAAA.DBM` contains a compact relationship list that decodes cleanly into quadruples:
  `(left_object, right_object, left_key, right_key)`.
- Decoded output written to `02_extracted_tables/RELAHAAA/relationships.csv`.

### DICTHAAA

- `DICTHAAA.DBM` is present but zero bytes in this archive, so dictionary content cannot be recovered from it.
  (If a non-empty DICT file exists in another copy, we can merge it later.)

### MENUHAAA

- `MENUHAAA.DBM` contains command/label pairs for the application menus.
- Decoded output written to `02_extracted_tables/MENUHAAA/menu_pairs.csv`.

### TOWNHAAA

- `TOWNHAAA.DBR` contains a token list for the town-wide surname search form/report (`TOWNSEARCH`).
- Extracted tokens written to `02_extracted_tables/TOWNHAAA/tosearch_tokens.csv`.
- `TOWNHAAA.DBF` contains mostly form text; it is not a standard dBase DBF in this archive.

### DBR/SCR/FMT/FMO (presentation layer)

- Token extracts were generated for all DBR/SCR/FMT/FMO files and summarised in `02_extracted_tables/_presentation/presentation_map.csv`.
- These files often encode screen/report/search labels and thus reflect the author’s intended way of reading the data.
